<?php
include_once "config.php"; // Ensure this file sets up any required global configuration.

// Parse state and city from the URL
$request_uri = $_SERVER['REQUEST_URI'];
$parts = explode('/', trim($request_uri, '/')); // e.g., ["tx", "houston.htm"]

// Extract and validate $state
$state = isset($parts[0]) ? strtoupper($parts[0]) : '';
$city = isset($parts[1]) ? strtolower(pathinfo($parts[1], PATHINFO_FILENAME)) : '';

$States = array("AK", "AL", "AR", "AZ", "CA", "CO", "CT", "DC", "DE", "FL", "GA", "HI", "IA", "ID", "IL", "IN", "KS", "KY", "LA", "MA", "MD", "ME", "MI", "MN", "MO", "MS", "MT", "NC", "ND", "NE", "NH", "NJ", "NM", "NV", "NY", "OH", "OK", "OR", "PA", "RI", "SC", "SD", "TN", "TX", "UT", "VA", "VT", "WA", "WI", "WV", "WY");
$StateListDescription = array("Alaska", "Alabama", "Arkansas", "Arizona", "California", "Colorado", "Connecticut", "Washington DC", "Delaware", "Florida", "Georgia", "Hawaii", "Iowa", "Idaho", "Illinois", "Indiana", "Kansas", "Kentucky", "Louisiana", "Massachusetts", "Maryland", "Maine", "Michigan", "Minnesota", "Missouri", "Mississippi", "Montana", "North Carolina", "North Dakota", "Nebraska", "New Hampshire", "New Jersey", "New Mexico", "Nevada", "New York", "Ohio", "Oklahoma", "Oregon", "Pennsylvania", "Rhode Island", "South Carolina", "South Dakota", "Tennessee", "Texas", "Utah", "Virginia", "Vermont", "Washington", "Wisconsin", "West Virginia", "Wyoming");

// Validate the state
if (!in_array($state, $States)) {
    echo "State find error. Invalid state: " . htmlspecialchars($state);
    exit;
}

// Get state description
$StateIndex = array_search($state, $States);
$statedesc = $StateListDescription[$StateIndex];
?>
<!DOCTYPE html>
<html>
<head>
    <title><?php echo $statedesc; ?> - State Page</title>
</head>
<body>
    <h1>Welcome to <?php echo $statedesc; ?></h1>
    <p>City: <?php echo htmlspecialchars($city); ?></p>
</body>
</html>
